import {
        async,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'

import { FhirConditionComponent } from './condition.component'
import { FhirCondition } from '../../../mccf-data/fhir/fhir-condition'

describe('FhirConditionComponent', () => {
  let component:  FhirConditionComponent
  let fixture: ComponentFixture< FhirConditionComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
         FhirConditionComponent
      ],
      providers: []
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent( FhirConditionComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    let cond = new FhirCondition()
    cond.ien = '2001'
    component.cond = cond
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('should have a condition loaded', ((done)=>{
    expect(component.cond.ien).toEqual('2001')
    done()
  }))

  it('should have no accessibility issues', ((done) => {
    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error('AXE-CORE ERROR:'+error)
    })
  }))
})
